﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace Azyobuzi.りすにんぐついったー
{
    [XmlRoot("condition")]
    public class ConditionItem
    {
        [XmlElement("title")]
        public string Title { set; get; }
        [XmlElement("artist")]
        public string Artist { set; get; }
        [XmlElement("album")]
        public string Album { set; get; }
        [XmlElement("template")]
        public string Template { set; get; }

        public override string ToString()
        {
            Func<string, string> func = (string s) => { if (string.IsNullOrEmpty(s)) return "指定なし"; else return s; };
            var sb = new StringBuilder();
            sb.AppendFormat("曲名：{0}\n", func(Title));
            sb.AppendFormat("アーティスト名：{0}\n", func(Artist));
            sb.AppendFormat("アルバム名：{0}\n", func(Album));
            sb.Append(Template);
            return sb.ToString();
        }

        public bool IsMatch(ListeningMusicChangedEventArgs obj)
        {
            bool b1, b2, b3;
            b1 = string.IsNullOrEmpty(Title) || Title == obj.Title;
            b2 = string.IsNullOrEmpty(Artist) || Artist == obj.Artist;
            b3 = string.IsNullOrEmpty(Album) || Album == obj.Album;
            return b1 && b2 && b3;
        }
    }
}
